package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRestoreImageTaskRequest(
    bucket: String,
    objectKey: String,
    name: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest = {
    import CreateRestoreImageTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .objectKey(objectKey: java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateRestoreImageTaskRequest.ReadOnly =
    zio.aws.ec2.model.CreateRestoreImageTaskRequest.wrap(buildAwsValue())
}
object CreateRestoreImageTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateRestoreImageTaskRequest =
      zio.aws.ec2.model.CreateRestoreImageTaskRequest(
        bucket,
        objectKey,
        name.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def bucket: String
    def objectKey: String
    def name: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getBucket: ZIO[Any, Nothing, String] = ZIO.succeed(bucket)
    def getObjectKey: ZIO[Any, Nothing, String] = ZIO.succeed(objectKey)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest
  ) extends zio.aws.ec2.model.CreateRestoreImageTaskRequest.ReadOnly {
    override val bucket: String = impl.bucket(): String
    override val objectKey: String = impl.objectKey(): String
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest
  ): zio.aws.ec2.model.CreateRestoreImageTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
