package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Port, NetworkInsightsResourceId, IpAddress}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateNetworkInsightsPathRequest(
    sourceIp: Optional[IpAddress] = Optional.Absent,
    destinationIp: Optional[IpAddress] = Optional.Absent,
    source: NetworkInsightsResourceId,
    destination: Optional[NetworkInsightsResourceId] = Optional.Absent,
    protocol: zio.aws.ec2.model.Protocol,
    destinationPort: Optional[Port] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    clientToken: String,
    filterAtSource: Optional[zio.aws.ec2.model.PathRequestFilter] =
      Optional.Absent,
    filterAtDestination: Optional[zio.aws.ec2.model.PathRequestFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest = {
    import CreateNetworkInsightsPathRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest
      .builder()
      .optionallyWith(
        sourceIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.sourceIp)
      .optionallyWith(
        destinationIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.destinationIp)
      .source(NetworkInsightsResourceId.unwrap(source): java.lang.String)
      .optionallyWith(
        destination.map(value =>
          NetworkInsightsResourceId.unwrap(value): java.lang.String
        )
      )(_.destination)
      .protocol(protocol.unwrap)
      .optionallyWith(
        destinationPort.map(value => Port.unwrap(value): Integer)
      )(_.destinationPort)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .clientToken(clientToken: java.lang.String)
      .optionallyWith(filterAtSource.map(value => value.buildAwsValue()))(
        _.filterAtSource
      )
      .optionallyWith(filterAtDestination.map(value => value.buildAwsValue()))(
        _.filterAtDestination
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNetworkInsightsPathRequest.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInsightsPathRequest.wrap(buildAwsValue())
}
object CreateNetworkInsightsPathRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInsightsPathRequest =
      zio.aws.ec2.model.CreateNetworkInsightsPathRequest(
        sourceIp.map(value => value),
        destinationIp.map(value => value),
        source,
        destination.map(value => value),
        protocol,
        destinationPort.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value),
        clientToken,
        filterAtSource.map(value => value.asEditable),
        filterAtDestination.map(value => value.asEditable)
      )
    def sourceIp: Optional[IpAddress]
    def destinationIp: Optional[IpAddress]
    def source: NetworkInsightsResourceId
    def destination: Optional[NetworkInsightsResourceId]
    def protocol: zio.aws.ec2.model.Protocol
    def destinationPort: Optional[Port]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def dryRun: Optional[Boolean]
    def clientToken: String
    def filterAtSource: Optional[zio.aws.ec2.model.PathRequestFilter.ReadOnly]
    def filterAtDestination
        : Optional[zio.aws.ec2.model.PathRequestFilter.ReadOnly]
    def getSourceIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("sourceIp", sourceIp)
    def getDestinationIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("destinationIp", destinationIp)
    def getSource: ZIO[Any, Nothing, NetworkInsightsResourceId] =
      ZIO.succeed(source)
    def getDestination: ZIO[Any, AwsError, NetworkInsightsResourceId] =
      AwsError.unwrapOptionField("destination", destination)
    def getProtocol: ZIO[Any, Nothing, zio.aws.ec2.model.Protocol] =
      ZIO.succeed(protocol)
    def getDestinationPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("destinationPort", destinationPort)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getClientToken: ZIO[Any, Nothing, String] = ZIO.succeed(clientToken)
    def getFilterAtSource
        : ZIO[Any, AwsError, zio.aws.ec2.model.PathRequestFilter.ReadOnly] =
      AwsError.unwrapOptionField("filterAtSource", filterAtSource)
    def getFilterAtDestination
        : ZIO[Any, AwsError, zio.aws.ec2.model.PathRequestFilter.ReadOnly] =
      AwsError.unwrapOptionField("filterAtDestination", filterAtDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest
  ) extends zio.aws.ec2.model.CreateNetworkInsightsPathRequest.ReadOnly {
    override val sourceIp: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIp())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val destinationIp: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationIp())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val source: NetworkInsightsResourceId =
      zio.aws.ec2.model.primitives.NetworkInsightsResourceId(impl.source())
    override val destination: Optional[NetworkInsightsResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value =>
          zio.aws.ec2.model.primitives.NetworkInsightsResourceId(value)
        )
    override val protocol: zio.aws.ec2.model.Protocol =
      zio.aws.ec2.model.Protocol.wrap(impl.protocol())
    override val destinationPort: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationPort())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val clientToken: String = impl.clientToken(): String
    override val filterAtSource
        : Optional[zio.aws.ec2.model.PathRequestFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterAtSource())
        .map(value => zio.aws.ec2.model.PathRequestFilter.wrap(value))
    override val filterAtDestination
        : Optional[zio.aws.ec2.model.PathRequestFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterAtDestination())
        .map(value => zio.aws.ec2.model.PathRequestFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest
  ): zio.aws.ec2.model.CreateNetworkInsightsPathRequest.ReadOnly = new Wrapper(
    impl
  )
}
