package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKeyPairRequest(
    keyName: String,
    dryRun: Optional[Boolean] = Optional.Absent,
    keyType: Optional[zio.aws.ec2.model.KeyType] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    keyFormat: Optional[zio.aws.ec2.model.KeyFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest = {
    import CreateKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest
      .builder()
      .keyName(keyName: java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(keyType.map(value => value.unwrap))(_.keyType)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(keyFormat.map(value => value.unwrap))(_.keyFormat)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateKeyPairRequest.ReadOnly =
    zio.aws.ec2.model.CreateKeyPairRequest.wrap(buildAwsValue())
}
object CreateKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateKeyPairRequest =
      zio.aws.ec2.model.CreateKeyPairRequest(
        keyName,
        dryRun.map(value => value),
        keyType.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        keyFormat.map(value => value)
      )
    def keyName: String
    def dryRun: Optional[Boolean]
    def keyType: Optional[zio.aws.ec2.model.KeyType]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def keyFormat: Optional[zio.aws.ec2.model.KeyFormat]
    def getKeyName: ZIO[Any, Nothing, String] = ZIO.succeed(keyName)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getKeyType: ZIO[Any, AwsError, zio.aws.ec2.model.KeyType] =
      AwsError.unwrapOptionField("keyType", keyType)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getKeyFormat: ZIO[Any, AwsError, zio.aws.ec2.model.KeyFormat] =
      AwsError.unwrapOptionField("keyFormat", keyFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest
  ) extends zio.aws.ec2.model.CreateKeyPairRequest.ReadOnly {
    override val keyName: String = impl.keyName(): String
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val keyType: Optional[zio.aws.ec2.model.KeyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyType())
        .map(value => zio.aws.ec2.model.KeyType.wrap(value))
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val keyFormat: Optional[zio.aws.ec2.model.KeyFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyFormat())
        .map(value => zio.aws.ec2.model.KeyFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest
  ): zio.aws.ec2.model.CreateKeyPairRequest.ReadOnly = new Wrapper(impl)
}
