package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateIpamRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    operatingRegions: Optional[
      Iterable[zio.aws.ec2.model.AddIpamOperatingRegion]
    ] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateIpamRequest = {
    import CreateIpamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateIpamRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        operatingRegions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operatingRegions)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateIpamRequest.ReadOnly =
    zio.aws.ec2.model.CreateIpamRequest.wrap(buildAwsValue())
}
object CreateIpamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateIpamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateIpamRequest =
      zio.aws.ec2.model.CreateIpamRequest(
        dryRun.map(value => value),
        description.map(value => value),
        operatingRegions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def description: Optional[String]
    def operatingRegions
        : Optional[List[zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly]]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getOperatingRegions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly
    ]] = AwsError.unwrapOptionField("operatingRegions", operatingRegions)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamRequest
  ) extends zio.aws.ec2.model.CreateIpamRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val operatingRegions
        : Optional[List[zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AddIpamOperatingRegion.wrap(item)
          }.toList
        )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamRequest
  ): zio.aws.ec2.model.CreateIpamRequest.ReadOnly = new Wrapper(impl)
}
