package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceEventWindowCronExpression
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateInstanceEventWindowRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    timeRanges: Optional[
      Iterable[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest]
    ] = Optional.Absent,
    cronExpression: Optional[InstanceEventWindowCronExpression] =
      Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest = {
    import CreateInstanceEventWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        timeRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeRanges)
      .optionallyWith(
        cronExpression.map(value =>
          InstanceEventWindowCronExpression.unwrap(value): java.lang.String
        )
      )(_.cronExpression)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateInstanceEventWindowRequest.ReadOnly =
    zio.aws.ec2.model.CreateInstanceEventWindowRequest.wrap(buildAwsValue())
}
object CreateInstanceEventWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateInstanceEventWindowRequest =
      zio.aws.ec2.model.CreateInstanceEventWindowRequest(
        dryRun.map(value => value),
        name.map(value => value),
        timeRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cronExpression.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dryRun: Optional[Boolean]
    def name: Optional[String]
    def timeRanges: Optional[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly]
    ]
    def cronExpression: Optional[InstanceEventWindowCronExpression]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getTimeRanges: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("timeRanges", timeRanges)
    def getCronExpression
        : ZIO[Any, AwsError, InstanceEventWindowCronExpression] =
      AwsError.unwrapOptionField("cronExpression", cronExpression)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest
  ) extends zio.aws.ec2.model.CreateInstanceEventWindowRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val timeRanges: Optional[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.wrap(item)
        }.toList
      )
    override val cronExpression: Optional[InstanceEventWindowCronExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cronExpression())
        .map(value =>
          zio.aws.ec2.model.primitives.InstanceEventWindowCronExpression(value)
        )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest
  ): zio.aws.ec2.model.CreateInstanceEventWindowRequest.ReadOnly = new Wrapper(
    impl
  )
}
