package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFpgaImageRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    inputStorageLocation: zio.aws.ec2.model.StorageLocation,
    logsStorageLocation: Optional[zio.aws.ec2.model.StorageLocation] =
      Optional.Absent,
    description: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest = {
    import CreateFpgaImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .inputStorageLocation(inputStorageLocation.buildAwsValue())
      .optionallyWith(logsStorageLocation.map(value => value.buildAwsValue()))(
        _.logsStorageLocation
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateFpgaImageRequest.ReadOnly =
    zio.aws.ec2.model.CreateFpgaImageRequest.wrap(buildAwsValue())
}
object CreateFpgaImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateFpgaImageRequest =
      zio.aws.ec2.model.CreateFpgaImageRequest(
        dryRun.map(value => value),
        inputStorageLocation.asEditable,
        logsStorageLocation.map(value => value.asEditable),
        description.map(value => value),
        name.map(value => value),
        clientToken.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dryRun: Optional[Boolean]
    def inputStorageLocation: zio.aws.ec2.model.StorageLocation.ReadOnly
    def logsStorageLocation
        : Optional[zio.aws.ec2.model.StorageLocation.ReadOnly]
    def description: Optional[String]
    def name: Optional[String]
    def clientToken: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInputStorageLocation
        : ZIO[Any, Nothing, zio.aws.ec2.model.StorageLocation.ReadOnly] =
      ZIO.succeed(inputStorageLocation)
    def getLogsStorageLocation
        : ZIO[Any, AwsError, zio.aws.ec2.model.StorageLocation.ReadOnly] =
      AwsError.unwrapOptionField("logsStorageLocation", logsStorageLocation)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest
  ) extends zio.aws.ec2.model.CreateFpgaImageRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val inputStorageLocation
        : zio.aws.ec2.model.StorageLocation.ReadOnly =
      zio.aws.ec2.model.StorageLocation.wrap(impl.inputStorageLocation())
    override val logsStorageLocation
        : Optional[zio.aws.ec2.model.StorageLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logsStorageLocation())
        .map(value => zio.aws.ec2.model.StorageLocation.wrap(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest
  ): zio.aws.ec2.model.CreateFpgaImageRequest.ReadOnly = new Wrapper(impl)
}
