package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class CreateFleetRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    spotOptions: Optional[zio.aws.ec2.model.SpotOptionsRequest] =
      Optional.Absent,
    onDemandOptions: Optional[zio.aws.ec2.model.OnDemandOptionsRequest] =
      Optional.Absent,
    excessCapacityTerminationPolicy: Optional[
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = Optional.Absent,
    launchTemplateConfigs: Iterable[
      zio.aws.ec2.model.FleetLaunchTemplateConfigRequest
    ],
    targetCapacitySpecification: zio.aws.ec2.model.TargetCapacitySpecificationRequest,
    terminateInstancesWithExpiration: Optional[Boolean] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.FleetType] = Optional.Absent,
    validFrom: Optional[DateTime] = Optional.Absent,
    validUntil: Optional[DateTime] = Optional.Absent,
    replaceUnhealthyInstances: Optional[Boolean] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    context: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateFleetRequest = {
    import CreateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateFleetRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(spotOptions.map(value => value.buildAwsValue()))(
        _.spotOptions
      )
      .optionallyWith(onDemandOptions.map(value => value.buildAwsValue()))(
        _.onDemandOptions
      )
      .optionallyWith(
        excessCapacityTerminationPolicy.map(value => value.unwrap)
      )(_.excessCapacityTerminationPolicy)
      .launchTemplateConfigs(launchTemplateConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .targetCapacitySpecification(targetCapacitySpecification.buildAwsValue())
      .optionallyWith(
        terminateInstancesWithExpiration.map(value => value: java.lang.Boolean)
      )(_.terminateInstancesWithExpiration)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(validFrom.map(value => DateTime.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(
        replaceUnhealthyInstances.map(value => value: java.lang.Boolean)
      )(_.replaceUnhealthyInstances)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(context.map(value => value: java.lang.String))(_.context)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateFleetRequest.ReadOnly =
    zio.aws.ec2.model.CreateFleetRequest.wrap(buildAwsValue())
}
object CreateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateFleetRequest =
      zio.aws.ec2.model.CreateFleetRequest(
        dryRun.map(value => value),
        clientToken.map(value => value),
        spotOptions.map(value => value.asEditable),
        onDemandOptions.map(value => value.asEditable),
        excessCapacityTerminationPolicy.map(value => value),
        launchTemplateConfigs.map { item =>
          item.asEditable
        },
        targetCapacitySpecification.asEditable,
        terminateInstancesWithExpiration.map(value => value),
        `type`.map(value => value),
        validFrom.map(value => value),
        validUntil.map(value => value),
        replaceUnhealthyInstances.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        context.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def clientToken: Optional[String]
    def spotOptions: Optional[zio.aws.ec2.model.SpotOptionsRequest.ReadOnly]
    def onDemandOptions
        : Optional[zio.aws.ec2.model.OnDemandOptionsRequest.ReadOnly]
    def excessCapacityTerminationPolicy
        : Optional[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy]
    def launchTemplateConfigs
        : List[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly]
    def targetCapacitySpecification
        : zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly
    def terminateInstancesWithExpiration: Optional[Boolean]
    def `type`: Optional[zio.aws.ec2.model.FleetType]
    def validFrom: Optional[DateTime]
    def validUntil: Optional[DateTime]
    def replaceUnhealthyInstances: Optional[Boolean]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def context: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSpotOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotOptionsRequest.ReadOnly] =
      AwsError.unwrapOptionField("spotOptions", spotOptions)
    def getOnDemandOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.OnDemandOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("onDemandOptions", onDemandOptions)
    def getExcessCapacityTerminationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = AwsError.unwrapOptionField(
      "excessCapacityTerminationPolicy",
      excessCapacityTerminationPolicy
    )
    def getLaunchTemplateConfigs: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly
    ]] = ZIO.succeed(launchTemplateConfigs)
    def getTargetCapacitySpecification: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly
    ] = ZIO.succeed(targetCapacitySpecification)
    def getTerminateInstancesWithExpiration: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "terminateInstancesWithExpiration",
        terminateInstancesWithExpiration
      )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.FleetType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValidFrom: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getReplaceUnhealthyInstances: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("replaceUnhealthyInstances", replaceUnhealthyInstances)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("context", context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateFleetRequest
  ) extends zio.aws.ec2.model.CreateFleetRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val spotOptions
        : Optional[zio.aws.ec2.model.SpotOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotOptions())
        .map(value => zio.aws.ec2.model.SpotOptionsRequest.wrap(value))
    override val onDemandOptions
        : Optional[zio.aws.ec2.model.OnDemandOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandOptions())
        .map(value => zio.aws.ec2.model.OnDemandOptionsRequest.wrap(value))
    override val excessCapacityTerminationPolicy
        : Optional[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excessCapacityTerminationPolicy())
        .map(value =>
          zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy.wrap(value)
        )
    override val launchTemplateConfigs
        : List[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly] =
      impl
        .launchTemplateConfigs()
        .asScala
        .map { item =>
          zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.wrap(item)
        }
        .toList
    override val targetCapacitySpecification
        : zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly =
      zio.aws.ec2.model.TargetCapacitySpecificationRequest
        .wrap(impl.targetCapacitySpecification())
    override val terminateInstancesWithExpiration: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminateInstancesWithExpiration())
        .map(value => value: Boolean)
    override val `type`: Optional[zio.aws.ec2.model.FleetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.FleetType.wrap(value))
    override val validFrom: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validFrom())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val validUntil: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val replaceUnhealthyInstances: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replaceUnhealthyInstances())
        .map(value => value: Boolean)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val context: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.context())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateFleetRequest
  ): zio.aws.ec2.model.CreateFleetRequest.ReadOnly = new Wrapper(impl)
}
