package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LocalGatewayRoutetableId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCoipPoolRequest(
    localGatewayRouteTableId: LocalGatewayRoutetableId,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCoipPoolRequest = {
    import CreateCoipPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCoipPoolRequest
      .builder()
      .localGatewayRouteTableId(
        LocalGatewayRoutetableId.unwrap(
          localGatewayRouteTableId
        ): java.lang.String
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateCoipPoolRequest.ReadOnly =
    zio.aws.ec2.model.CreateCoipPoolRequest.wrap(buildAwsValue())
}
object CreateCoipPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCoipPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCoipPoolRequest =
      zio.aws.ec2.model.CreateCoipPoolRequest(
        localGatewayRouteTableId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def localGatewayRouteTableId: LocalGatewayRoutetableId
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getLocalGatewayRouteTableId
        : ZIO[Any, Nothing, LocalGatewayRoutetableId] =
      ZIO.succeed(localGatewayRouteTableId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCoipPoolRequest
  ) extends zio.aws.ec2.model.CreateCoipPoolRequest.ReadOnly {
    override val localGatewayRouteTableId: LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRoutetableId(impl.localGatewayRouteTableId())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCoipPoolRequest
  ): zio.aws.ec2.model.CreateCoipPoolRequest.ReadOnly = new Wrapper(impl)
}
