package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, SecurityGroupId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateClientVpnEndpointRequest(
    clientCidrBlock: String,
    serverCertificateArn: String,
    authenticationOptions: Iterable[
      zio.aws.ec2.model.ClientVpnAuthenticationRequest
    ],
    connectionLogOptions: zio.aws.ec2.model.ConnectionLogOptions,
    dnsServers: Optional[Iterable[String]] = Optional.Absent,
    transportProtocol: Optional[zio.aws.ec2.model.TransportProtocol] =
      Optional.Absent,
    vpnPort: Optional[Integer] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    splitTunnel: Optional[Boolean] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    selfServicePortal: Optional[zio.aws.ec2.model.SelfServicePortal] =
      Optional.Absent,
    clientConnectOptions: Optional[zio.aws.ec2.model.ClientConnectOptions] =
      Optional.Absent,
    sessionTimeoutHours: Optional[Integer] = Optional.Absent,
    clientLoginBannerOptions: Optional[
      zio.aws.ec2.model.ClientLoginBannerOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest = {
    import CreateClientVpnEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest
      .builder()
      .clientCidrBlock(clientCidrBlock: java.lang.String)
      .serverCertificateArn(serverCertificateArn: java.lang.String)
      .authenticationOptions(authenticationOptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .connectionLogOptions(connectionLogOptions.buildAwsValue())
      .optionallyWith(
        dnsServers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dnsServers)
      .optionallyWith(transportProtocol.map(value => value.unwrap))(
        _.transportProtocol
      )
      .optionallyWith(vpnPort.map(value => value: java.lang.Integer))(_.vpnPort)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(splitTunnel.map(value => value: java.lang.Boolean))(
        _.splitTunnel
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(selfServicePortal.map(value => value.unwrap))(
        _.selfServicePortal
      )
      .optionallyWith(clientConnectOptions.map(value => value.buildAwsValue()))(
        _.clientConnectOptions
      )
      .optionallyWith(
        sessionTimeoutHours.map(value => value: java.lang.Integer)
      )(_.sessionTimeoutHours)
      .optionallyWith(
        clientLoginBannerOptions.map(value => value.buildAwsValue())
      )(_.clientLoginBannerOptions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateClientVpnEndpointRequest.ReadOnly =
    zio.aws.ec2.model.CreateClientVpnEndpointRequest.wrap(buildAwsValue())
}
object CreateClientVpnEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateClientVpnEndpointRequest =
      zio.aws.ec2.model.CreateClientVpnEndpointRequest(
        clientCidrBlock,
        serverCertificateArn,
        authenticationOptions.map { item =>
          item.asEditable
        },
        connectionLogOptions.asEditable,
        dnsServers.map(value => value),
        transportProtocol.map(value => value),
        vpnPort.map(value => value),
        description.map(value => value),
        splitTunnel.map(value => value),
        dryRun.map(value => value),
        clientToken.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupIds.map(value => value),
        vpcId.map(value => value),
        selfServicePortal.map(value => value),
        clientConnectOptions.map(value => value.asEditable),
        sessionTimeoutHours.map(value => value),
        clientLoginBannerOptions.map(value => value.asEditable)
      )
    def clientCidrBlock: String
    def serverCertificateArn: String
    def authenticationOptions
        : List[zio.aws.ec2.model.ClientVpnAuthenticationRequest.ReadOnly]
    def connectionLogOptions: zio.aws.ec2.model.ConnectionLogOptions.ReadOnly
    def dnsServers: Optional[List[String]]
    def transportProtocol: Optional[zio.aws.ec2.model.TransportProtocol]
    def vpnPort: Optional[Integer]
    def description: Optional[String]
    def splitTunnel: Optional[Boolean]
    def dryRun: Optional[Boolean]
    def clientToken: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def vpcId: Optional[VpcId]
    def selfServicePortal: Optional[zio.aws.ec2.model.SelfServicePortal]
    def clientConnectOptions
        : Optional[zio.aws.ec2.model.ClientConnectOptions.ReadOnly]
    def sessionTimeoutHours: Optional[Integer]
    def clientLoginBannerOptions
        : Optional[zio.aws.ec2.model.ClientLoginBannerOptions.ReadOnly]
    def getClientCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(clientCidrBlock)
    def getServerCertificateArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(serverCertificateArn)
    def getAuthenticationOptions: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.ClientVpnAuthenticationRequest.ReadOnly
    ]] = ZIO.succeed(authenticationOptions)
    def getConnectionLogOptions
        : ZIO[Any, Nothing, zio.aws.ec2.model.ConnectionLogOptions.ReadOnly] =
      ZIO.succeed(connectionLogOptions)
    def getDnsServers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dnsServers", dnsServers)
    def getTransportProtocol
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransportProtocol] =
      AwsError.unwrapOptionField("transportProtocol", transportProtocol)
    def getVpnPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vpnPort", vpnPort)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSplitTunnel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("splitTunnel", splitTunnel)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSelfServicePortal
        : ZIO[Any, AwsError, zio.aws.ec2.model.SelfServicePortal] =
      AwsError.unwrapOptionField("selfServicePortal", selfServicePortal)
    def getClientConnectOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientConnectOptions.ReadOnly] =
      AwsError.unwrapOptionField("clientConnectOptions", clientConnectOptions)
    def getSessionTimeoutHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sessionTimeoutHours", sessionTimeoutHours)
    def getClientLoginBannerOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientLoginBannerOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clientLoginBannerOptions",
      clientLoginBannerOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest
  ) extends zio.aws.ec2.model.CreateClientVpnEndpointRequest.ReadOnly {
    override val clientCidrBlock: String = impl.clientCidrBlock(): String
    override val serverCertificateArn: String =
      impl.serverCertificateArn(): String
    override val authenticationOptions
        : List[zio.aws.ec2.model.ClientVpnAuthenticationRequest.ReadOnly] = impl
      .authenticationOptions()
      .asScala
      .map { item =>
        zio.aws.ec2.model.ClientVpnAuthenticationRequest.wrap(item)
      }
      .toList
    override val connectionLogOptions
        : zio.aws.ec2.model.ConnectionLogOptions.ReadOnly =
      zio.aws.ec2.model.ConnectionLogOptions.wrap(impl.connectionLogOptions())
    override val dnsServers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsServers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val transportProtocol
        : Optional[zio.aws.ec2.model.TransportProtocol] = zio.aws.core.internal
      .optionalFromNullable(impl.transportProtocol())
      .map(value => zio.aws.ec2.model.TransportProtocol.wrap(value))
    override val vpnPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnPort())
      .map(value => value: Integer)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val splitTunnel: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.splitTunnel())
      .map(value => value: Boolean)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
    override val selfServicePortal
        : Optional[zio.aws.ec2.model.SelfServicePortal] = zio.aws.core.internal
      .optionalFromNullable(impl.selfServicePortal())
      .map(value => zio.aws.ec2.model.SelfServicePortal.wrap(value))
    override val clientConnectOptions
        : Optional[zio.aws.ec2.model.ClientConnectOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientConnectOptions())
        .map(value => zio.aws.ec2.model.ClientConnectOptions.wrap(value))
    override val sessionTimeoutHours: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionTimeoutHours())
      .map(value => value: Integer)
    override val clientLoginBannerOptions
        : Optional[zio.aws.ec2.model.ClientLoginBannerOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientLoginBannerOptions())
        .map(value => zio.aws.ec2.model.ClientLoginBannerOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest
  ): zio.aws.ec2.model.CreateClientVpnEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
