package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConversionTask(
    conversionTaskId: Optional[String] = Optional.Absent,
    expirationTime: Optional[String] = Optional.Absent,
    importInstance: Optional[zio.aws.ec2.model.ImportInstanceTaskDetails] =
      Optional.Absent,
    importVolume: Optional[zio.aws.ec2.model.ImportVolumeTaskDetails] =
      Optional.Absent,
    state: Optional[zio.aws.ec2.model.ConversionTaskState] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ConversionTask = {
    import ConversionTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ConversionTask
      .builder()
      .optionallyWith(conversionTaskId.map(value => value: java.lang.String))(
        _.conversionTaskId
      )
      .optionallyWith(expirationTime.map(value => value: java.lang.String))(
        _.expirationTime
      )
      .optionallyWith(importInstance.map(value => value.buildAwsValue()))(
        _.importInstance
      )
      .optionallyWith(importVolume.map(value => value.buildAwsValue()))(
        _.importVolume
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ConversionTask.ReadOnly =
    zio.aws.ec2.model.ConversionTask.wrap(buildAwsValue())
}
object ConversionTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ConversionTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ConversionTask =
      zio.aws.ec2.model.ConversionTask(
        conversionTaskId.map(value => value),
        expirationTime.map(value => value),
        importInstance.map(value => value.asEditable),
        importVolume.map(value => value.asEditable),
        state.map(value => value),
        statusMessage.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def conversionTaskId: Optional[String]
    def expirationTime: Optional[String]
    def importInstance
        : Optional[zio.aws.ec2.model.ImportInstanceTaskDetails.ReadOnly]
    def importVolume
        : Optional[zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly]
    def state: Optional[zio.aws.ec2.model.ConversionTaskState]
    def statusMessage: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getConversionTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("conversionTaskId", conversionTaskId)
    def getExpirationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getImportInstance: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ImportInstanceTaskDetails.ReadOnly
    ] = AwsError.unwrapOptionField("importInstance", importInstance)
    def getImportVolume: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly
    ] = AwsError.unwrapOptionField("importVolume", importVolume)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ConversionTaskState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ConversionTask
  ) extends zio.aws.ec2.model.ConversionTask.ReadOnly {
    override val conversionTaskId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.conversionTaskId())
      .map(value => value: String)
    override val expirationTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationTime())
      .map(value => value: String)
    override val importInstance
        : Optional[zio.aws.ec2.model.ImportInstanceTaskDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importInstance())
        .map(value => zio.aws.ec2.model.ImportInstanceTaskDetails.wrap(value))
    override val importVolume
        : Optional[zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importVolume())
        .map(value => zio.aws.ec2.model.ImportVolumeTaskDetails.wrap(value))
    override val state: Optional[zio.aws.ec2.model.ConversionTaskState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.ConversionTaskState.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ConversionTask
  ): zio.aws.ec2.model.ConversionTask.ReadOnly = new Wrapper(impl)
}
