package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CapacityReservationType {
  def unwrap: software.amazon.awssdk.services.ec2.model.CapacityReservationType
}
object CapacityReservationType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CapacityReservationType
  ): zio.aws.ec2.model.CapacityReservationType = value match {
    case software.amazon.awssdk.services.ec2.model.CapacityReservationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationType.DEFAULT =>
      val r = default
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationType.CAPACITY_BLOCK =>
      val r = `capacity-block`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.CapacityReservationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationType =
      software.amazon.awssdk.services.ec2.model.CapacityReservationType.UNKNOWN_TO_SDK_VERSION
  }
  case object default extends zio.aws.ec2.model.CapacityReservationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationType =
      software.amazon.awssdk.services.ec2.model.CapacityReservationType.DEFAULT
  }
  case object `capacity-block`
      extends zio.aws.ec2.model.CapacityReservationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationType =
      software.amazon.awssdk.services.ec2.model.CapacityReservationType.CAPACITY_BLOCK
  }
}
