package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{MillisecondDateTime, Integer, OfferingId}
import scala.jdk.CollectionConverters._
final case class CapacityBlockOffering(
    capacityBlockOfferingId: Optional[OfferingId] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    instanceCount: Optional[Integer] = Optional.Absent,
    startDate: Optional[MillisecondDateTime] = Optional.Absent,
    endDate: Optional[MillisecondDateTime] = Optional.Absent,
    capacityBlockDurationHours: Optional[Integer] = Optional.Absent,
    upfrontFee: Optional[String] = Optional.Absent,
    currencyCode: Optional[String] = Optional.Absent,
    tenancy: Optional[zio.aws.ec2.model.CapacityReservationTenancy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityBlockOffering = {
    import CapacityBlockOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityBlockOffering
      .builder()
      .optionallyWith(
        capacityBlockOfferingId.map(value =>
          OfferingId.unwrap(value): java.lang.String
        )
      )(_.capacityBlockOfferingId)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(
        startDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startDate)
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(
        capacityBlockDurationHours.map(value => value: java.lang.Integer)
      )(_.capacityBlockDurationHours)
      .optionallyWith(upfrontFee.map(value => value: java.lang.String))(
        _.upfrontFee
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityBlockOffering.ReadOnly =
    zio.aws.ec2.model.CapacityBlockOffering.wrap(buildAwsValue())
}
object CapacityBlockOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityBlockOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityBlockOffering =
      zio.aws.ec2.model.CapacityBlockOffering(
        capacityBlockOfferingId.map(value => value),
        instanceType.map(value => value),
        availabilityZone.map(value => value),
        instanceCount.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        capacityBlockDurationHours.map(value => value),
        upfrontFee.map(value => value),
        currencyCode.map(value => value),
        tenancy.map(value => value)
      )
    def capacityBlockOfferingId: Optional[OfferingId]
    def instanceType: Optional[String]
    def availabilityZone: Optional[String]
    def instanceCount: Optional[Integer]
    def startDate: Optional[MillisecondDateTime]
    def endDate: Optional[MillisecondDateTime]
    def capacityBlockDurationHours: Optional[Integer]
    def upfrontFee: Optional[String]
    def currencyCode: Optional[String]
    def tenancy: Optional[zio.aws.ec2.model.CapacityReservationTenancy]
    def getCapacityBlockOfferingId: ZIO[Any, AwsError, OfferingId] = AwsError
      .unwrapOptionField("capacityBlockOfferingId", capacityBlockOfferingId)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getStartDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getCapacityBlockDurationHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "capacityBlockDurationHours",
        capacityBlockDurationHours
      )
    def getUpfrontFee: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("upfrontFee", upfrontFee)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getTenancy
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationTenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityBlockOffering
  ) extends zio.aws.ec2.model.CapacityBlockOffering.ReadOnly {
    override val capacityBlockOfferingId: Optional[OfferingId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityBlockOfferingId())
        .map(value => zio.aws.ec2.model.primitives.OfferingId(value))
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val startDate: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startDate())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endDate: Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val capacityBlockDurationHours: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityBlockDurationHours())
        .map(value => value: Integer)
    override val upfrontFee: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.upfrontFee())
      .map(value => value: String)
    override val currencyCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currencyCode())
      .map(value => value: String)
    override val tenancy
        : Optional[zio.aws.ec2.model.CapacityReservationTenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value => zio.aws.ec2.model.CapacityReservationTenancy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityBlockOffering
  ): zio.aws.ec2.model.CapacityBlockOffering.ReadOnly = new Wrapper(impl)
}
