package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CapacityAllocation(
    allocationType: Optional[zio.aws.ec2.model.AllocationType] =
      Optional.Absent,
    count: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityAllocation = {
    import CapacityAllocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityAllocation
      .builder()
      .optionallyWith(allocationType.map(value => value.unwrap))(
        _.allocationType
      )
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityAllocation.ReadOnly =
    zio.aws.ec2.model.CapacityAllocation.wrap(buildAwsValue())
}
object CapacityAllocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityAllocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityAllocation =
      zio.aws.ec2.model.CapacityAllocation(
        allocationType.map(value => value),
        count.map(value => value)
      )
    def allocationType: Optional[zio.aws.ec2.model.AllocationType]
    def count: Optional[Integer]
    def getAllocationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.AllocationType] =
      AwsError.unwrapOptionField("allocationType", allocationType)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityAllocation
  ) extends zio.aws.ec2.model.CapacityAllocation.ReadOnly {
    override val allocationType: Optional[zio.aws.ec2.model.AllocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationType())
        .map(value => zio.aws.ec2.model.AllocationType.wrap(value))
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityAllocation
  ): zio.aws.ec2.model.CapacityAllocation.ReadOnly = new Wrapper(impl)
}
