package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SpotFleetRequestId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelSpotFleetRequestsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    spotFleetRequestIds: Iterable[SpotFleetRequestId],
    terminateInstances: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest = {
    import CancelSpotFleetRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .spotFleetRequestIds(spotFleetRequestIds.map { item =>
        SpotFleetRequestId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .terminateInstances(terminateInstances: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelSpotFleetRequestsRequest.ReadOnly =
    zio.aws.ec2.model.CancelSpotFleetRequestsRequest.wrap(buildAwsValue())
}
object CancelSpotFleetRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelSpotFleetRequestsRequest =
      zio.aws.ec2.model.CancelSpotFleetRequestsRequest(
        dryRun.map(value => value),
        spotFleetRequestIds,
        terminateInstances
      )
    def dryRun: Optional[Boolean]
    def spotFleetRequestIds: List[SpotFleetRequestId]
    def terminateInstances: Boolean
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getSpotFleetRequestIds: ZIO[Any, Nothing, List[SpotFleetRequestId]] =
      ZIO.succeed(spotFleetRequestIds)
    def getTerminateInstances: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(terminateInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest
  ) extends zio.aws.ec2.model.CancelSpotFleetRequestsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val spotFleetRequestIds: List[SpotFleetRequestId] = impl
      .spotFleetRequestIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SpotFleetRequestId(item)
      }
      .toList
    override val terminateInstances: Boolean =
      impl.terminateInstances(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest
  ): zio.aws.ec2.model.CancelSpotFleetRequestsRequest.ReadOnly = new Wrapper(
    impl
  )
}
