package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait BootModeValues {
  def unwrap: software.amazon.awssdk.services.ec2.model.BootModeValues
}
object BootModeValues {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.BootModeValues
  ): zio.aws.ec2.model.BootModeValues = value match {
    case software.amazon.awssdk.services.ec2.model.BootModeValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.BootModeValues.LEGACY_BIOS =>
      val r = `legacy-bios`
      r
    case software.amazon.awssdk.services.ec2.model.BootModeValues.UEFI =>
      val r = uefi
      r
    case software.amazon.awssdk.services.ec2.model.BootModeValues.UEFI_PREFERRED =>
      val r = `uefi-preferred`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.BootModeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BootModeValues =
      software.amazon.awssdk.services.ec2.model.BootModeValues.UNKNOWN_TO_SDK_VERSION
  }
  case object `legacy-bios` extends zio.aws.ec2.model.BootModeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BootModeValues =
      software.amazon.awssdk.services.ec2.model.BootModeValues.LEGACY_BIOS
  }
  case object uefi extends zio.aws.ec2.model.BootModeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BootModeValues =
      software.amazon.awssdk.services.ec2.model.BootModeValues.UEFI
  }
  case object `uefi-preferred` extends zio.aws.ec2.model.BootModeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BootModeValues =
      software.amazon.awssdk.services.ec2.model.BootModeValues.UEFI_PREFERRED
  }
}
