package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AutoAcceptSharedAttachmentsValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue
}
object AutoAcceptSharedAttachmentsValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue
  ): zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue = value match {
    case software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue =
      software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable
      extends zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue =
      software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue.ENABLE
  }
  case object disable
      extends zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue =
      software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue.DISABLE
  }
}
