package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachmentEnaSrdUdpSpecification(
    enaSrdUdpEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachmentEnaSrdUdpSpecification = {
    import AttachmentEnaSrdUdpSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachmentEnaSrdUdpSpecification
      .builder()
      .optionallyWith(enaSrdUdpEnabled.map(value => value: java.lang.Boolean))(
        _.enaSrdUdpEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachmentEnaSrdUdpSpecification.ReadOnly =
    zio.aws.ec2.model.AttachmentEnaSrdUdpSpecification.wrap(buildAwsValue())
}
object AttachmentEnaSrdUdpSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachmentEnaSrdUdpSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachmentEnaSrdUdpSpecification =
      zio.aws.ec2.model
        .AttachmentEnaSrdUdpSpecification(enaSrdUdpEnabled.map(value => value))
    def enaSrdUdpEnabled: Optional[Boolean]
    def getEnaSrdUdpEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enaSrdUdpEnabled", enaSrdUdpEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachmentEnaSrdUdpSpecification
  ) extends zio.aws.ec2.model.AttachmentEnaSrdUdpSpecification.ReadOnly {
    override val enaSrdUdpEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enaSrdUdpEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachmentEnaSrdUdpSpecification
  ): zio.aws.ec2.model.AttachmentEnaSrdUdpSpecification.ReadOnly = new Wrapper(
    impl
  )
}
