package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpnGatewayId, VpcId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachVpnGatewayRequest(
    vpcId: VpcId,
    vpnGatewayId: VpnGatewayId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest = {
    import AttachVpnGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .vpnGatewayId(VpnGatewayId.unwrap(vpnGatewayId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachVpnGatewayRequest.ReadOnly =
    zio.aws.ec2.model.AttachVpnGatewayRequest.wrap(buildAwsValue())
}
object AttachVpnGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachVpnGatewayRequest =
      zio.aws.ec2.model.AttachVpnGatewayRequest(
        vpcId,
        vpnGatewayId,
        dryRun.map(value => value)
      )
    def vpcId: VpcId
    def vpnGatewayId: VpnGatewayId
    def dryRun: Optional[Boolean]
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getVpnGatewayId: ZIO[Any, Nothing, VpnGatewayId] =
      ZIO.succeed(vpnGatewayId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest
  ) extends zio.aws.ec2.model.AttachVpnGatewayRequest.ReadOnly {
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val vpnGatewayId: VpnGatewayId =
      zio.aws.ec2.model.primitives.VpnGatewayId(impl.vpnGatewayId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest
  ): zio.aws.ec2.model.AttachVpnGatewayRequest.ReadOnly = new Wrapper(impl)
}
