package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, ClientVpnEndpointId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateClientVpnTargetNetworkRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    subnetId: SubnetId,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest = {
    import AssociateClientVpnTargetNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest.ReadOnly =
    zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest
      .wrap(buildAwsValue())
}
object AssociateClientVpnTargetNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest =
      zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest(
        clientVpnEndpointId,
        subnetId,
        clientToken.map(value => value),
        dryRun.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def subnetId: SubnetId
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest
  ) extends zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest
  ): zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
