package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalysisSecurityGroupRule(
    cidr: Optional[String] = Optional.Absent,
    direction: Optional[String] = Optional.Absent,
    securityGroupId: Optional[String] = Optional.Absent,
    portRange: Optional[zio.aws.ec2.model.PortRange] = Optional.Absent,
    prefixListId: Optional[String] = Optional.Absent,
    protocol: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AnalysisSecurityGroupRule = {
    import AnalysisSecurityGroupRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AnalysisSecurityGroupRule
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(direction.map(value => value: java.lang.String))(
        _.direction
      )
      .optionallyWith(securityGroupId.map(value => value: java.lang.String))(
        _.securityGroupId
      )
      .optionallyWith(portRange.map(value => value.buildAwsValue()))(
        _.portRange
      )
      .optionallyWith(prefixListId.map(value => value: java.lang.String))(
        _.prefixListId
      )
      .optionallyWith(protocol.map(value => value: java.lang.String))(
        _.protocol
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly =
    zio.aws.ec2.model.AnalysisSecurityGroupRule.wrap(buildAwsValue())
}
object AnalysisSecurityGroupRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AnalysisSecurityGroupRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AnalysisSecurityGroupRule =
      zio.aws.ec2.model.AnalysisSecurityGroupRule(
        cidr.map(value => value),
        direction.map(value => value),
        securityGroupId.map(value => value),
        portRange.map(value => value.asEditable),
        prefixListId.map(value => value),
        protocol.map(value => value)
      )
    def cidr: Optional[String]
    def direction: Optional[String]
    def securityGroupId: Optional[String]
    def portRange: Optional[zio.aws.ec2.model.PortRange.ReadOnly]
    def prefixListId: Optional[String]
    def protocol: Optional[String]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getDirection: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("direction", direction)
    def getSecurityGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("securityGroupId", securityGroupId)
    def getPortRange: ZIO[Any, AwsError, zio.aws.ec2.model.PortRange.ReadOnly] =
      AwsError.unwrapOptionField("portRange", portRange)
    def getPrefixListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisSecurityGroupRule
  ) extends zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly {
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
    override val direction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.direction())
      .map(value => value: String)
    override val securityGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroupId())
      .map(value => value: String)
    override val portRange: Optional[zio.aws.ec2.model.PortRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portRange())
        .map(value => zio.aws.ec2.model.PortRange.wrap(value))
    override val prefixListId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListId())
      .map(value => value: String)
    override val protocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisSecurityGroupRule
  ): zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly = new Wrapper(impl)
}
