package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AddressTransferStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.AddressTransferStatus
}
object AddressTransferStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AddressTransferStatus
  ): zio.aws.ec2.model.AddressTransferStatus = value match {
    case software.amazon.awssdk.services.ec2.model.AddressTransferStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AddressTransferStatus.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.AddressTransferStatus.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.ec2.model.AddressTransferStatus.ACCEPTED =>
      val r = accepted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AddressTransferStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AddressTransferStatus =
      software.amazon.awssdk.services.ec2.model.AddressTransferStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.AddressTransferStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AddressTransferStatus =
      software.amazon.awssdk.services.ec2.model.AddressTransferStatus.PENDING
  }
  case object disabled extends zio.aws.ec2.model.AddressTransferStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AddressTransferStatus =
      software.amazon.awssdk.services.ec2.model.AddressTransferStatus.DISABLED
  }
  case object accepted extends zio.aws.ec2.model.AddressTransferStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AddressTransferStatus =
      software.amazon.awssdk.services.ec2.model.AddressTransferStatus.ACCEPTED
  }
}
