package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptTransitGatewayVpcAttachmentRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest = {
    import AcceptTransitGatewayVpcAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
      .wrap(buildAwsValue())
}
object AcceptTransitGatewayVpcAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest =
      zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest(
        transitGatewayAttachmentId,
        dryRun.map(value => value)
      )
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def dryRun: Optional[Boolean]
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
  ) extends zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
  ): zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
