package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpnTunnelLogOptionsSpecification(
    cloudWatchLogOptions: Optional[
      zio.aws.ec2.model.CloudWatchLogOptionsSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptionsSpecification = {
    import VpnTunnelLogOptionsSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptionsSpecification
      .builder()
      .optionallyWith(cloudWatchLogOptions.map(value => value.buildAwsValue()))(
        _.cloudWatchLogOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnTunnelLogOptionsSpecification.ReadOnly =
    zio.aws.ec2.model.VpnTunnelLogOptionsSpecification.wrap(buildAwsValue())
}
object VpnTunnelLogOptionsSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptionsSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnTunnelLogOptionsSpecification =
      zio.aws.ec2.model.VpnTunnelLogOptionsSpecification(
        cloudWatchLogOptions.map(value => value.asEditable)
      )
    def cloudWatchLogOptions
        : Optional[zio.aws.ec2.model.CloudWatchLogOptionsSpecification.ReadOnly]
    def getCloudWatchLogOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CloudWatchLogOptionsSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogOptions", cloudWatchLogOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptionsSpecification
  ) extends zio.aws.ec2.model.VpnTunnelLogOptionsSpecification.ReadOnly {
    override val cloudWatchLogOptions: Optional[
      zio.aws.ec2.model.CloudWatchLogOptionsSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogOptions())
      .map(value =>
        zio.aws.ec2.model.CloudWatchLogOptionsSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptionsSpecification
  ): zio.aws.ec2.model.VpnTunnelLogOptionsSpecification.ReadOnly = new Wrapper(
    impl
  )
}
