package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessLogS3Destination(
    enabled: Optional[Boolean] = Optional.Absent,
    deliveryStatus: Optional[
      zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus
    ] = Optional.Absent,
    bucketName: Optional[String] = Optional.Absent,
    prefix: Optional[String] = Optional.Absent,
    bucketOwner: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3Destination = {
    import VerifiedAccessLogS3Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3Destination
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(deliveryStatus.map(value => value.buildAwsValue()))(
        _.deliveryStatus
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(bucketOwner.map(value => value: java.lang.String))(
        _.bucketOwner
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VerifiedAccessLogS3Destination.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessLogS3Destination.wrap(buildAwsValue())
}
object VerifiedAccessLogS3Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessLogS3Destination =
      zio.aws.ec2.model.VerifiedAccessLogS3Destination(
        enabled.map(value => value),
        deliveryStatus.map(value => value.asEditable),
        bucketName.map(value => value),
        prefix.map(value => value),
        bucketOwner.map(value => value)
      )
    def enabled: Optional[Boolean]
    def deliveryStatus
        : Optional[zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly]
    def bucketName: Optional[String]
    def prefix: Optional[String]
    def bucketOwner: Optional[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getDeliveryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly
    ] = AwsError.unwrapOptionField("deliveryStatus", deliveryStatus)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getBucketOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketOwner", bucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3Destination
  ) extends zio.aws.ec2.model.VerifiedAccessLogS3Destination.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val deliveryStatus
        : Optional[zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryStatus())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.wrap(value)
        )
    override val bucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: String)
    override val prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: String)
    override val bucketOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketOwner())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3Destination
  ): zio.aws.ec2.model.VerifiedAccessLogS3Destination.ReadOnly = new Wrapper(
    impl
  )
}
