package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessLogOptions(
    s3: Optional[zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions] =
      Optional.Absent,
    cloudWatchLogs: Optional[
      zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions
    ] = Optional.Absent,
    kinesisDataFirehose: Optional[
      zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions
    ] = Optional.Absent,
    logVersion: Optional[String] = Optional.Absent,
    includeTrustContext: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessLogOptions = {
    import VerifiedAccessLogOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogOptions
      .builder()
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(kinesisDataFirehose.map(value => value.buildAwsValue()))(
        _.kinesisDataFirehose
      )
      .optionallyWith(logVersion.map(value => value: java.lang.String))(
        _.logVersion
      )
      .optionallyWith(
        includeTrustContext.map(value => value: java.lang.Boolean)
      )(_.includeTrustContext)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VerifiedAccessLogOptions.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessLogOptions.wrap(buildAwsValue())
}
object VerifiedAccessLogOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessLogOptions =
      zio.aws.ec2.model.VerifiedAccessLogOptions(
        s3.map(value => value.asEditable),
        cloudWatchLogs.map(value => value.asEditable),
        kinesisDataFirehose.map(value => value.asEditable),
        logVersion.map(value => value),
        includeTrustContext.map(value => value)
      )
    def s3: Optional[
      zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions.ReadOnly
    ]
    def cloudWatchLogs: Optional[
      zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions.ReadOnly
    ]
    def kinesisDataFirehose: Optional[
      zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions.ReadOnly
    ]
    def logVersion: Optional[String]
    def includeTrustContext: Optional[Boolean]
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getKinesisDataFirehose: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisDataFirehose", kinesisDataFirehose)
    def getLogVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logVersion", logVersion)
    def getIncludeTrustContext: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeTrustContext", includeTrustContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogOptions
  ) extends zio.aws.ec2.model.VerifiedAccessLogOptions.ReadOnly {
    override val s3: Optional[
      zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions.wrap(value)
      )
    override val cloudWatchLogs: Optional[
      zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogs())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions
          .wrap(value)
      )
    override val kinesisDataFirehose: Optional[
      zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisDataFirehose())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions
          .wrap(value)
      )
    override val logVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logVersion())
      .map(value => value: String)
    override val includeTrustContext: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeTrustContext())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogOptions
  ): zio.aws.ec2.model.VerifiedAccessLogOptions.ReadOnly = new Wrapper(impl)
}
