package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SpotFleetTagSpecification(
    resourceType: Optional[zio.aws.ec2.model.ResourceType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotFleetTagSpecification = {
    import SpotFleetTagSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotFleetTagSpecification
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotFleetTagSpecification.ReadOnly =
    zio.aws.ec2.model.SpotFleetTagSpecification.wrap(buildAwsValue())
}
object SpotFleetTagSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotFleetTagSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotFleetTagSpecification =
      zio.aws.ec2.model.SpotFleetTagSpecification(
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceType: Optional[zio.aws.ec2.model.ResourceType]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getResourceType: ZIO[Any, AwsError, zio.aws.ec2.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetTagSpecification
  ) extends zio.aws.ec2.model.SpotFleetTagSpecification.ReadOnly {
    override val resourceType: Optional[zio.aws.ec2.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.ec2.model.ResourceType.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetTagSpecification
  ): zio.aws.ec2.model.SpotFleetTagSpecification.ReadOnly = new Wrapper(impl)
}
