package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreSnapshotFromRecycleBinRequest(
    snapshotId: SnapshotId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest = {
    import RestoreSnapshotFromRecycleBinRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest
      .builder()
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest.ReadOnly =
    zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest.wrap(buildAwsValue())
}
object RestoreSnapshotFromRecycleBinRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest =
      zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest(
        snapshotId,
        dryRun.map(value => value)
      )
    def snapshotId: SnapshotId
    def dryRun: Optional[Boolean]
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest
  ) extends zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest.ReadOnly {
    override val snapshotId: SnapshotId =
      zio.aws.ec2.model.primitives.SnapshotId(impl.snapshotId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest
  ): zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest.ReadOnly =
    new Wrapper(impl)
}
