package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FpgaImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetFpgaImageAttributeRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    fpgaImageId: FpgaImageId,
    attribute: Optional[zio.aws.ec2.model.ResetFpgaImageAttributeName] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest = {
    import ResetFpgaImageAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .fpgaImageId(FpgaImageId.unwrap(fpgaImageId): java.lang.String)
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResetFpgaImageAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ResetFpgaImageAttributeRequest.wrap(buildAwsValue())
}
object ResetFpgaImageAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResetFpgaImageAttributeRequest =
      zio.aws.ec2.model.ResetFpgaImageAttributeRequest(
        dryRun.map(value => value),
        fpgaImageId,
        attribute.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def fpgaImageId: FpgaImageId
    def attribute: Optional[zio.aws.ec2.model.ResetFpgaImageAttributeName]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFpgaImageId: ZIO[Any, Nothing, FpgaImageId] =
      ZIO.succeed(fpgaImageId)
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.ec2.model.ResetFpgaImageAttributeName] =
      AwsError.unwrapOptionField("attribute", attribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest
  ) extends zio.aws.ec2.model.ResetFpgaImageAttributeRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val fpgaImageId: FpgaImageId =
      zio.aws.ec2.model.primitives.FpgaImageId(impl.fpgaImageId())
    override val attribute
        : Optional[zio.aws.ec2.model.ResetFpgaImageAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value => zio.aws.ec2.model.ResetFpgaImageAttributeName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest
  ): zio.aws.ec2.model.ResetFpgaImageAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
