package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.AllocationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetAddressAttributeRequest(
    allocationId: AllocationId,
    attribute: zio.aws.ec2.model.AddressAttributeName,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest = {
    import ResetAddressAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest
      .builder()
      .allocationId(AllocationId.unwrap(allocationId): java.lang.String)
      .attribute(attribute.unwrap)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResetAddressAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ResetAddressAttributeRequest.wrap(buildAwsValue())
}
object ResetAddressAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResetAddressAttributeRequest =
      zio.aws.ec2.model.ResetAddressAttributeRequest(
        allocationId,
        attribute,
        dryRun.map(value => value)
      )
    def allocationId: AllocationId
    def attribute: zio.aws.ec2.model.AddressAttributeName
    def dryRun: Optional[Boolean]
    def getAllocationId: ZIO[Any, Nothing, AllocationId] =
      ZIO.succeed(allocationId)
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.ec2.model.AddressAttributeName] =
      ZIO.succeed(attribute)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest
  ) extends zio.aws.ec2.model.ResetAddressAttributeRequest.ReadOnly {
    override val allocationId: AllocationId =
      zio.aws.ec2.model.primitives.AllocationId(impl.allocationId())
    override val attribute: zio.aws.ec2.model.AddressAttributeName =
      zio.aws.ec2.model.AddressAttributeName.wrap(impl.attribute())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest
  ): zio.aws.ec2.model.ResetAddressAttributeRequest.ReadOnly = new Wrapper(impl)
}
