package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RequestIpamResourceTag(
    key: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag = {
    import RequestIpamResourceTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly =
    zio.aws.ec2.model.RequestIpamResourceTag.wrap(buildAwsValue())
}
object RequestIpamResourceTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestIpamResourceTag =
      zio.aws.ec2.model.RequestIpamResourceTag(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Optional[String]
    def value: Optional[String]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag
  ) extends zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly {
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag
  ): zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly = new Wrapper(impl)
}
