package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.Port
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RequestFilterPortRange(
    fromPort: Optional[Port] = Optional.Absent,
    toPort: Optional[Port] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestFilterPortRange = {
    import RequestFilterPortRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestFilterPortRange
      .builder()
      .optionallyWith(fromPort.map(value => Port.unwrap(value): Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => Port.unwrap(value): Integer))(
        _.toPort
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestFilterPortRange.ReadOnly =
    zio.aws.ec2.model.RequestFilterPortRange.wrap(buildAwsValue())
}
object RequestFilterPortRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestFilterPortRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestFilterPortRange =
      zio.aws.ec2.model.RequestFilterPortRange(
        fromPort.map(value => value),
        toPort.map(value => value)
      )
    def fromPort: Optional[Port]
    def toPort: Optional[Port]
    def getFromPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("toPort", toPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestFilterPortRange
  ) extends zio.aws.ec2.model.RequestFilterPortRange.ReadOnly {
    override val fromPort: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
    override val toPort: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestFilterPortRange
  ): zio.aws.ec2.model.RequestFilterPortRange.ReadOnly = new Wrapper(impl)
}
