package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{RouteTableId, RouteTableAssociationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplaceRouteTableAssociationRequest(
    associationId: RouteTableAssociationId,
    dryRun: Optional[Boolean] = Optional.Absent,
    routeTableId: RouteTableId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest = {
    import ReplaceRouteTableAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest
      .builder()
      .associationId(
        RouteTableAssociationId.unwrap(associationId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .routeTableId(RouteTableId.unwrap(routeTableId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ReplaceRouteTableAssociationRequest.ReadOnly =
    zio.aws.ec2.model.ReplaceRouteTableAssociationRequest.wrap(buildAwsValue())
}
object ReplaceRouteTableAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceRouteTableAssociationRequest =
      zio.aws.ec2.model.ReplaceRouteTableAssociationRequest(
        associationId,
        dryRun.map(value => value),
        routeTableId
      )
    def associationId: RouteTableAssociationId
    def dryRun: Optional[Boolean]
    def routeTableId: RouteTableId
    def getAssociationId: ZIO[Any, Nothing, RouteTableAssociationId] =
      ZIO.succeed(associationId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getRouteTableId: ZIO[Any, Nothing, RouteTableId] =
      ZIO.succeed(routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest
  ) extends zio.aws.ec2.model.ReplaceRouteTableAssociationRequest.ReadOnly {
    override val associationId: RouteTableAssociationId =
      zio.aws.ec2.model.primitives.RouteTableAssociationId(impl.associationId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val routeTableId: RouteTableId =
      zio.aws.ec2.model.primitives.RouteTableId(impl.routeTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest
  ): zio.aws.ec2.model.ReplaceRouteTableAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
