package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplaceNetworkAclAssociationResponse(
    newAssociationId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse = {
    import ReplaceNetworkAclAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse
      .builder()
      .optionallyWith(newAssociationId.map(value => value: java.lang.String))(
        _.newAssociationId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse.ReadOnly =
    zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse.wrap(buildAwsValue())
}
object ReplaceNetworkAclAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse =
      zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse(
        newAssociationId.map(value => value)
      )
    def newAssociationId: Optional[String]
    def getNewAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newAssociationId", newAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse
  ) extends zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse.ReadOnly {
    override val newAssociationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.newAssociationId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse
  ): zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
