package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterTransitGatewayMulticastGroupSourcesResponse(
    registeredMulticastGroupSources: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse = {
    import RegisterTransitGatewayMulticastGroupSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse
      .builder()
      .optionallyWith(
        registeredMulticastGroupSources.map(value => value.buildAwsValue())
      )(_.registeredMulticastGroupSources)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly =
    zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse
      .wrap(buildAwsValue())
}
object RegisterTransitGatewayMulticastGroupSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse =
      zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse(
        registeredMulticastGroupSources.map(value => value.asEditable)
      )
    def registeredMulticastGroupSources: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources.ReadOnly
    ]
    def getRegisteredMulticastGroupSources: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources.ReadOnly
    ] = AwsError.unwrapOptionField(
      "registeredMulticastGroupSources",
      registeredMulticastGroupSources
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse
  ) extends zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly {
    override val registeredMulticastGroupSources: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredMulticastGroupSources())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupSources
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse
  ): zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly =
    new Wrapper(impl)
}
