package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PurchaseCapacityBlockResponse(
    capacityReservation: Optional[zio.aws.ec2.model.CapacityReservation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockResponse = {
    import PurchaseCapacityBlockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockResponse
      .builder()
      .optionallyWith(capacityReservation.map(value => value.buildAwsValue()))(
        _.capacityReservation
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PurchaseCapacityBlockResponse.ReadOnly =
    zio.aws.ec2.model.PurchaseCapacityBlockResponse.wrap(buildAwsValue())
}
object PurchaseCapacityBlockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PurchaseCapacityBlockResponse =
      zio.aws.ec2.model.PurchaseCapacityBlockResponse(
        capacityReservation.map(value => value.asEditable)
      )
    def capacityReservation
        : Optional[zio.aws.ec2.model.CapacityReservation.ReadOnly]
    def getCapacityReservation
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservation.ReadOnly] =
      AwsError.unwrapOptionField("capacityReservation", capacityReservation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockResponse
  ) extends zio.aws.ec2.model.PurchaseCapacityBlockResponse.ReadOnly {
    override val capacityReservation
        : Optional[zio.aws.ec2.model.CapacityReservation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservation())
        .map(value => zio.aws.ec2.model.CapacityReservation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockResponse
  ): zio.aws.ec2.model.PurchaseCapacityBlockResponse.ReadOnly = new Wrapper(
    impl
  )
}
