package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NitroTpmSupportedVersionType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NitroTpmInfo(
    supportedVersions: Optional[Iterable[NitroTpmSupportedVersionType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NitroTpmInfo = {
    import NitroTpmInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NitroTpmInfo
      .builder()
      .optionallyWith(
        supportedVersions.map(value =>
          value.map { item =>
            NitroTpmSupportedVersionType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedVersions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NitroTpmInfo.ReadOnly =
    zio.aws.ec2.model.NitroTpmInfo.wrap(buildAwsValue())
}
object NitroTpmInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.NitroTpmInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NitroTpmInfo =
      zio.aws.ec2.model.NitroTpmInfo(supportedVersions.map(value => value))
    def supportedVersions: Optional[List[NitroTpmSupportedVersionType]]
    def getSupportedVersions
        : ZIO[Any, AwsError, List[NitroTpmSupportedVersionType]] =
      AwsError.unwrapOptionField("supportedVersions", supportedVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NitroTpmInfo
  ) extends zio.aws.ec2.model.NitroTpmInfo.ReadOnly {
    override val supportedVersions
        : Optional[List[NitroTpmSupportedVersionType]] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.NitroTpmSupportedVersionType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NitroTpmInfo
  ): zio.aws.ec2.model.NitroTpmInfo.ReadOnly = new Wrapper(impl)
}
