package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkInterfacePermissionState(
    state: Optional[zio.aws.ec2.model.NetworkInterfacePermissionStateCode] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionState = {
    import NetworkInterfacePermissionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionState
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInterfacePermissionState.ReadOnly =
    zio.aws.ec2.model.NetworkInterfacePermissionState.wrap(buildAwsValue())
}
object NetworkInterfacePermissionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInterfacePermissionState =
      zio.aws.ec2.model.NetworkInterfacePermissionState(
        state.map(value => value),
        statusMessage.map(value => value)
      )
    def state: Optional[zio.aws.ec2.model.NetworkInterfacePermissionStateCode]
    def statusMessage: Optional[String]
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfacePermissionStateCode
    ] = AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionState
  ) extends zio.aws.ec2.model.NetworkInterfacePermissionState.ReadOnly {
    override val state
        : Optional[zio.aws.ec2.model.NetworkInterfacePermissionStateCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.NetworkInterfacePermissionStateCode.wrap(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionState
  ): zio.aws.ec2.model.NetworkInterfacePermissionState.ReadOnly = new Wrapper(
    impl
  )
}
