package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  ResourceArn,
  NetworkInsightsAccessScopeId
}
import scala.jdk.CollectionConverters._
final case class NetworkInsightsAccessScope(
    networkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId] =
      Optional.Absent,
    networkInsightsAccessScopeArn: Optional[ResourceArn] = Optional.Absent,
    createdDate: Optional[MillisecondDateTime] = Optional.Absent,
    updatedDate: Optional[MillisecondDateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope = {
    import NetworkInsightsAccessScope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeId.map(value =>
          NetworkInsightsAccessScopeId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeId)
      .optionallyWith(
        networkInsightsAccessScopeArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeArn)
      .optionallyWith(
        createdDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        updatedDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.updatedDate)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly =
    zio.aws.ec2.model.NetworkInsightsAccessScope.wrap(buildAwsValue())
}
object NetworkInsightsAccessScope {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInsightsAccessScope =
      zio.aws.ec2.model.NetworkInsightsAccessScope(
        networkInsightsAccessScopeId.map(value => value),
        networkInsightsAccessScopeArn.map(value => value),
        createdDate.map(value => value),
        updatedDate.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]
    def networkInsightsAccessScopeArn: Optional[ResourceArn]
    def createdDate: Optional[MillisecondDateTime]
    def updatedDate: Optional[MillisecondDateTime]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeId",
        networkInsightsAccessScopeId
      )
    def getNetworkInsightsAccessScopeArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeArn",
        networkInsightsAccessScopeArn
      )
    def getCreatedDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getUpdatedDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("updatedDate", updatedDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope
  ) extends zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly {
    override val networkInsightsAccessScopeId
        : Optional[NetworkInsightsAccessScopeId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId(value)
      )
    override val networkInsightsAccessScopeArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsAccessScopeArn())
        .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val createdDate: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdDate())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val updatedDate: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedDate())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope
  ): zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly = new Wrapper(impl)
}
