package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessGroupPolicyRequest(
    verifiedAccessGroupId: VerifiedAccessGroupId,
    policyEnabled: Optional[Boolean] = Optional.Absent,
    policyDocument: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest = {
    import ModifyVerifiedAccessGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest
      .builder()
      .verifiedAccessGroupId(
        VerifiedAccessGroupId.unwrap(verifiedAccessGroupId): java.lang.String
      )
      .optionallyWith(policyEnabled.map(value => value: java.lang.Boolean))(
        _.policyEnabled
      )
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest =
      zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest(
        verifiedAccessGroupId,
        policyEnabled.map(value => value),
        policyDocument.map(value => value),
        clientToken.map(value => value),
        dryRun.map(value => value),
        sseSpecification.map(value => value.asEditable)
      )
    def verifiedAccessGroupId: VerifiedAccessGroupId
    def policyEnabled: Optional[Boolean]
    def policyDocument: Optional[String]
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ]
    def getVerifiedAccessGroupId: ZIO[Any, Nothing, VerifiedAccessGroupId] =
      ZIO.succeed(verifiedAccessGroupId)
    def getPolicyEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("policyEnabled", policyEnabled)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getSseSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("sseSpecification", sseSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest.ReadOnly {
    override val verifiedAccessGroupId: VerifiedAccessGroupId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessGroupId(impl.verifiedAccessGroupId())
    override val policyEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.policyEnabled())
      .map(value => value: Boolean)
    override val policyDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDocument())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sseSpecification())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest
  ): zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
