package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessEndpointPolicyRequest(
    verifiedAccessEndpointId: VerifiedAccessEndpointId,
    policyEnabled: Optional[Boolean] = Optional.Absent,
    policyDocument: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest = {
    import ModifyVerifiedAccessEndpointPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest
      .builder()
      .verifiedAccessEndpointId(
        VerifiedAccessEndpointId.unwrap(
          verifiedAccessEndpointId
        ): java.lang.String
      )
      .optionallyWith(policyEnabled.map(value => value: java.lang.Boolean))(
        _.policyEnabled
      )
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessEndpointPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest =
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest(
        verifiedAccessEndpointId,
        policyEnabled.map(value => value),
        policyDocument.map(value => value),
        clientToken.map(value => value),
        dryRun.map(value => value),
        sseSpecification.map(value => value.asEditable)
      )
    def verifiedAccessEndpointId: VerifiedAccessEndpointId
    def policyEnabled: Optional[Boolean]
    def policyDocument: Optional[String]
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ]
    def getVerifiedAccessEndpointId
        : ZIO[Any, Nothing, VerifiedAccessEndpointId] =
      ZIO.succeed(verifiedAccessEndpointId)
    def getPolicyEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("policyEnabled", policyEnabled)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getSseSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("sseSpecification", sseSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest.ReadOnly {
    override val verifiedAccessEndpointId: VerifiedAccessEndpointId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessEndpointId(impl.verifiedAccessEndpointId())
    override val policyEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.policyEnabled())
      .map(value => value: Boolean)
    override val policyDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDocument())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sseSpecification())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest
  ): zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
