package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyInstanceCreditSpecificationRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    instanceCreditSpecifications: Iterable[
      zio.aws.ec2.model.InstanceCreditSpecificationRequest
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest = {
    import ModifyInstanceCreditSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .instanceCreditSpecifications(instanceCreditSpecifications.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest
      .wrap(buildAwsValue())
}
object ModifyInstanceCreditSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest =
      zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest(
        dryRun.map(value => value),
        clientToken.map(value => value),
        instanceCreditSpecifications.map { item =>
          item.asEditable
        }
      )
    def dryRun: Optional[Boolean]
    def clientToken: Optional[String]
    def instanceCreditSpecifications
        : List[zio.aws.ec2.model.InstanceCreditSpecificationRequest.ReadOnly]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceCreditSpecifications: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.InstanceCreditSpecificationRequest.ReadOnly
    ]] = ZIO.succeed(instanceCreditSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest
  ) extends zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val instanceCreditSpecifications
        : List[zio.aws.ec2.model.InstanceCreditSpecificationRequest.ReadOnly] =
      impl
        .instanceCreditSpecifications()
        .asScala
        .map { item =>
          zio.aws.ec2.model.InstanceCreditSpecificationRequest.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest
  ): zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
