package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceGeneration {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceGeneration
}
object InstanceGeneration {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceGeneration
  ): zio.aws.ec2.model.InstanceGeneration = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceGeneration.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceGeneration.CURRENT =>
      val r = current
      r
    case software.amazon.awssdk.services.ec2.model.InstanceGeneration.PREVIOUS =>
      val r = previous
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.InstanceGeneration {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceGeneration =
      software.amazon.awssdk.services.ec2.model.InstanceGeneration.UNKNOWN_TO_SDK_VERSION
  }
  case object current extends zio.aws.ec2.model.InstanceGeneration {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceGeneration =
      software.amazon.awssdk.services.ec2.model.InstanceGeneration.CURRENT
  }
  case object previous extends zio.aws.ec2.model.InstanceGeneration {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceGeneration =
      software.amazon.awssdk.services.ec2.model.InstanceGeneration.PREVIOUS
  }
}
