package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceCapacity(
    availableCapacity: Optional[Integer] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    totalCapacity: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceCapacity = {
    import InstanceCapacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceCapacity
      .builder()
      .optionallyWith(availableCapacity.map(value => value: java.lang.Integer))(
        _.availableCapacity
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(totalCapacity.map(value => value: java.lang.Integer))(
        _.totalCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceCapacity.ReadOnly =
    zio.aws.ec2.model.InstanceCapacity.wrap(buildAwsValue())
}
object InstanceCapacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceCapacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceCapacity =
      zio.aws.ec2.model.InstanceCapacity(
        availableCapacity.map(value => value),
        instanceType.map(value => value),
        totalCapacity.map(value => value)
      )
    def availableCapacity: Optional[Integer]
    def instanceType: Optional[String]
    def totalCapacity: Optional[Integer]
    def getAvailableCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("availableCapacity", availableCapacity)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getTotalCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalCapacity", totalCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceCapacity
  ) extends zio.aws.ec2.model.InstanceCapacity.ReadOnly {
    override val availableCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.availableCapacity())
      .map(value => value: Integer)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val totalCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCapacity())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceCapacity
  ): zio.aws.ec2.model.InstanceCapacity.ReadOnly = new Wrapper(impl)
}
