package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ImageBlockPublicAccessEnabledState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessEnabledState
}
object ImageBlockPublicAccessEnabledState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessEnabledState
  ): zio.aws.ec2.model.ImageBlockPublicAccessEnabledState = value match {
    case software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessEnabledState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessEnabledState.BLOCK_NEW_SHARING =>
      val r = `block-new-sharing`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ImageBlockPublicAccessEnabledState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessEnabledState =
      software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessEnabledState.UNKNOWN_TO_SDK_VERSION
  }
  case object `block-new-sharing`
      extends zio.aws.ec2.model.ImageBlockPublicAccessEnabledState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessEnabledState =
      software.amazon.awssdk.services.ec2.model.ImageBlockPublicAccessEnabledState.BLOCK_NEW_SHARING
  }
}
