package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class HistoryRecord(
    eventInformation: Optional[zio.aws.ec2.model.EventInformation] =
      Optional.Absent,
    eventType: Optional[zio.aws.ec2.model.EventType] = Optional.Absent,
    timestamp: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HistoryRecord = {
    import HistoryRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HistoryRecord
      .builder()
      .optionallyWith(eventInformation.map(value => value.buildAwsValue()))(
        _.eventInformation
      )
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(timestamp.map(value => DateTime.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HistoryRecord.ReadOnly =
    zio.aws.ec2.model.HistoryRecord.wrap(buildAwsValue())
}
object HistoryRecord {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.HistoryRecord] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HistoryRecord =
      zio.aws.ec2.model.HistoryRecord(
        eventInformation.map(value => value.asEditable),
        eventType.map(value => value),
        timestamp.map(value => value)
      )
    def eventInformation: Optional[zio.aws.ec2.model.EventInformation.ReadOnly]
    def eventType: Optional[zio.aws.ec2.model.EventType]
    def timestamp: Optional[DateTime]
    def getEventInformation
        : ZIO[Any, AwsError, zio.aws.ec2.model.EventInformation.ReadOnly] =
      AwsError.unwrapOptionField("eventInformation", eventInformation)
    def getEventType: ZIO[Any, AwsError, zio.aws.ec2.model.EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HistoryRecord
  ) extends zio.aws.ec2.model.HistoryRecord.ReadOnly {
    override val eventInformation
        : Optional[zio.aws.ec2.model.EventInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventInformation())
        .map(value => zio.aws.ec2.model.EventInformation.wrap(value))
    override val eventType: Optional[zio.aws.ec2.model.EventType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventType())
        .map(value => zio.aws.ec2.model.EventType.wrap(value))
    override val timestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HistoryRecord
  ): zio.aws.ec2.model.HistoryRecord.ReadOnly = new Wrapper(impl)
}
