package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  SpotPlacementScoresMaxResults,
  SpotPlacementScoresTargetCapacity
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetSpotPlacementScoresRequest(
    instanceTypes: Optional[Iterable[String]] = Optional.Absent,
    targetCapacity: SpotPlacementScoresTargetCapacity,
    targetCapacityUnitType: Optional[zio.aws.ec2.model.TargetCapacityUnitType] =
      Optional.Absent,
    singleAvailabilityZone: Optional[Boolean] = Optional.Absent,
    regionNames: Optional[Iterable[String]] = Optional.Absent,
    instanceRequirementsWithMetadata: Optional[
      zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest
    ] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[SpotPlacementScoresMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest = {
    import GetSpotPlacementScoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest
      .builder()
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .targetCapacity(
        SpotPlacementScoresTargetCapacity.unwrap(targetCapacity): Integer
      )
      .optionallyWith(targetCapacityUnitType.map(value => value.unwrap))(
        _.targetCapacityUnitType
      )
      .optionallyWith(
        singleAvailabilityZone.map(value => value: java.lang.Boolean)
      )(_.singleAvailabilityZone)
      .optionallyWith(
        regionNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.regionNames)
      .optionallyWith(
        instanceRequirementsWithMetadata.map(value => value.buildAwsValue())
      )(_.instanceRequirementsWithMetadata)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        maxResults.map(value =>
          SpotPlacementScoresMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetSpotPlacementScoresRequest.ReadOnly =
    zio.aws.ec2.model.GetSpotPlacementScoresRequest.wrap(buildAwsValue())
}
object GetSpotPlacementScoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetSpotPlacementScoresRequest =
      zio.aws.ec2.model.GetSpotPlacementScoresRequest(
        instanceTypes.map(value => value),
        targetCapacity,
        targetCapacityUnitType.map(value => value),
        singleAvailabilityZone.map(value => value),
        regionNames.map(value => value),
        instanceRequirementsWithMetadata.map(value => value.asEditable),
        dryRun.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceTypes: Optional[List[String]]
    def targetCapacity: SpotPlacementScoresTargetCapacity
    def targetCapacityUnitType
        : Optional[zio.aws.ec2.model.TargetCapacityUnitType]
    def singleAvailabilityZone: Optional[Boolean]
    def regionNames: Optional[List[String]]
    def instanceRequirementsWithMetadata: Optional[
      zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.ReadOnly
    ]
    def dryRun: Optional[Boolean]
    def maxResults: Optional[SpotPlacementScoresMaxResults]
    def nextToken: Optional[String]
    def getInstanceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getTargetCapacity
        : ZIO[Any, Nothing, SpotPlacementScoresTargetCapacity] =
      ZIO.succeed(targetCapacity)
    def getTargetCapacityUnitType
        : ZIO[Any, AwsError, zio.aws.ec2.model.TargetCapacityUnitType] =
      AwsError.unwrapOptionField(
        "targetCapacityUnitType",
        targetCapacityUnitType
      )
    def getSingleAvailabilityZone: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("singleAvailabilityZone", singleAvailabilityZone)
    def getRegionNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("regionNames", regionNames)
    def getInstanceRequirementsWithMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceRequirementsWithMetadata",
      instanceRequirementsWithMetadata
    )
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getMaxResults: ZIO[Any, AwsError, SpotPlacementScoresMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest
  ) extends zio.aws.ec2.model.GetSpotPlacementScoresRequest.ReadOnly {
    override val instanceTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val targetCapacity: SpotPlacementScoresTargetCapacity =
      zio.aws.ec2.model.primitives
        .SpotPlacementScoresTargetCapacity(impl.targetCapacity())
    override val targetCapacityUnitType
        : Optional[zio.aws.ec2.model.TargetCapacityUnitType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetCapacityUnitType())
        .map(value => zio.aws.ec2.model.TargetCapacityUnitType.wrap(value))
    override val singleAvailabilityZone: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleAvailabilityZone())
        .map(value => value: Boolean)
    override val regionNames: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.regionNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val instanceRequirementsWithMetadata: Optional[
      zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceRequirementsWithMetadata())
      .map(value =>
        zio.aws.ec2.model.InstanceRequirementsWithMetadataRequest.wrap(value)
      )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val maxResults: Optional[SpotPlacementScoresMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.SpotPlacementScoresMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest
  ): zio.aws.ec2.model.GetSpotPlacementScoresRequest.ReadOnly = new Wrapper(
    impl
  )
}
