package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  NetworkInsightsMaxResults,
  NetworkInsightsAccessScopeAnalysisId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetNetworkInsightsAccessScopeAnalysisFindingsRequest(
    networkInsightsAccessScopeAnalysisId: NetworkInsightsAccessScopeAnalysisId,
    maxResults: Optional[NetworkInsightsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest = {
    import GetNetworkInsightsAccessScopeAnalysisFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
      .builder()
      .networkInsightsAccessScopeAnalysisId(
        NetworkInsightsAccessScopeAnalysisId.unwrap(
          networkInsightsAccessScopeAnalysisId
        ): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value =>
          NetworkInsightsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest.ReadOnly =
    zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
      .wrap(buildAwsValue())
}
object GetNetworkInsightsAccessScopeAnalysisFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest =
      zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest(
        networkInsightsAccessScopeAnalysisId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        dryRun.map(value => value)
      )
    def networkInsightsAccessScopeAnalysisId
        : NetworkInsightsAccessScopeAnalysisId
    def maxResults: Optional[NetworkInsightsMaxResults]
    def nextToken: Optional[NextToken]
    def dryRun: Optional[Boolean]
    def getNetworkInsightsAccessScopeAnalysisId
        : ZIO[Any, Nothing, NetworkInsightsAccessScopeAnalysisId] =
      ZIO.succeed(networkInsightsAccessScopeAnalysisId)
    def getMaxResults: ZIO[Any, AwsError, NetworkInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
  ) extends zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest.ReadOnly {
    override val networkInsightsAccessScopeAnalysisId
        : NetworkInsightsAccessScopeAnalysisId =
      zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId(
        impl.networkInsightsAccessScopeAnalysisId()
      )
    override val maxResults: Optional[NetworkInsightsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.NetworkInsightsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
  ): zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest.ReadOnly =
    new Wrapper(impl)
}
