package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  GetManagedPrefixListAssociationsMaxResults,
  PrefixListResourceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetManagedPrefixListAssociationsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    prefixListId: PrefixListResourceId,
    maxResults: Optional[GetManagedPrefixListAssociationsMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest = {
    import GetManagedPrefixListAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          GetManagedPrefixListAssociationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest.ReadOnly =
    zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest
      .wrap(buildAwsValue())
}
object GetManagedPrefixListAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest =
      zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest(
        dryRun.map(value => value),
        prefixListId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def prefixListId: PrefixListResourceId
    def maxResults: Optional[GetManagedPrefixListAssociationsMaxResults]
    def nextToken: Optional[NextToken]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
    def getMaxResults
        : ZIO[Any, AwsError, GetManagedPrefixListAssociationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest
  ) extends zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
    override val maxResults
        : Optional[GetManagedPrefixListAssociationsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .GetManagedPrefixListAssociationsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest
  ): zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
