package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLaunchTemplateDataRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest = {
    import GetLaunchTemplateDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetLaunchTemplateDataRequest.ReadOnly =
    zio.aws.ec2.model.GetLaunchTemplateDataRequest.wrap(buildAwsValue())
}
object GetLaunchTemplateDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetLaunchTemplateDataRequest =
      zio.aws.ec2.model
        .GetLaunchTemplateDataRequest(dryRun.map(value => value), instanceId)
    def dryRun: Optional[Boolean]
    def instanceId: InstanceId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest
  ) extends zio.aws.ec2.model.GetLaunchTemplateDataRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest
  ): zio.aws.ec2.model.GetLaunchTemplateDataRequest.ReadOnly = new Wrapper(impl)
}
