package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInstanceUefiDataResponse(
    instanceId: Optional[InstanceId] = Optional.Absent,
    uefiData: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataResponse = {
    import GetInstanceUefiDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataResponse
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(uefiData.map(value => value: java.lang.String))(
        _.uefiData
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetInstanceUefiDataResponse.ReadOnly =
    zio.aws.ec2.model.GetInstanceUefiDataResponse.wrap(buildAwsValue())
}
object GetInstanceUefiDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetInstanceUefiDataResponse =
      zio.aws.ec2.model.GetInstanceUefiDataResponse(
        instanceId.map(value => value),
        uefiData.map(value => value)
      )
    def instanceId: Optional[InstanceId]
    def uefiData: Optional[String]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getUefiData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uefiData", uefiData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataResponse
  ) extends zio.aws.ec2.model.GetInstanceUefiDataResponse.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ec2.model.primitives.InstanceId(value))
    override val uefiData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.uefiData())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataResponse
  ): zio.aws.ec2.model.GetInstanceUefiDataResponse.ReadOnly = new Wrapper(impl)
}
